/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.entities.FallingIcicleEntity;
import com.ordana.immersive_weathering.entities.IcicleBlockEntity;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModDamageSource;
import com.ordana.immersive_weathering.reg.ModTags;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5689;
import net.minecraft.class_5691;
import net.minecraft.class_5714;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class IcicleBlock
extends class_5689
implements class_2343 {
    public IcicleBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654((class_2769)field_28050) == class_2350.field_11033 && state.method_11654((class_2769)field_28051) == class_5691.field_28065) {
            return new IcicleBlockEntity(pos, state);
        }
        return null;
    }

    @Nullable
    public <T extends class_2586> class_5714 method_32896(class_3218 serverLevel, T blockEntity) {
        IcicleBlockEntity t;
        return blockEntity instanceof IcicleBlockEntity ? (t = (IcicleBlockEntity)blockEntity) : null;
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 hitResult, class_1676 projectile) {
        class_2338 blockpos = hitResult.method_17777();
        if (!level.field_9236 && projectile.method_36971(level, blockpos) && projectile.method_18798().method_1033() > 0.6) {
            level.method_22352(blockpos, true);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return IcicleBlock.isValidIciclePlacement(world, pos, (class_2350)state.method_11654((class_2769)field_28050));
    }

    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)field_28052)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (dir != class_2350.field_11036 && dir != class_2350.field_11033) {
            return state;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_28050);
        if (direction == class_2350.field_11033 && level.method_8397().method_8674(pos, (Object)this)) {
            return state;
        }
        if (dir == direction.method_10153() && !this.method_9558(state, (class_4538)level, pos)) {
            if (direction == class_2350.field_11033) {
                level.method_39279(pos, (class_2248)this, 2);
            } else {
                level.method_39279(pos, (class_2248)this, 1);
            }
            return state;
        }
        boolean flag = state.method_11654((class_2769)field_28051) == class_5691.field_28064;
        class_5691 dripstonethickness = IcicleBlock.calculateIcicleThickness((class_4538)level, pos, direction, flag);
        return (class_2680)state.method_11657((class_2769)field_28051, (Comparable)dripstonethickness);
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (state.method_11654((class_2769)field_28050) == class_2350.field_11036 && state.method_11654((class_2769)field_28051) == class_5691.field_28065) {
            entity.method_5747(fallDistance + 2.0f, 3.5f, ModDamageSource.ICICLE);
            if (!world.field_9236) {
                int freezing = CommonConfigs.FREEZING_ICICLE_SEVERITY.get();
                WeatheringHelper.applyFreezing(entity, freezing);
            }
        } else {
            entity.method_5747(fallDistance, 1.0f, class_1282.field_5868);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        Optional<class_3611> optional;
        float f;
        if (IcicleBlock.canDrip(state) && !((f = random.method_43057()) > 0.12f) && (optional = IcicleBlock.getFluidAboveStalactite(world, pos, state)).filter(fluid -> IcicleBlock.isValidDripFluid(fluid) || !((class_1959)world.method_23753(pos).comp_349()).method_33599(pos) && f < 0.02f).isPresent()) {
            IcicleBlock.spawnDripParticle(world, pos, state, optional.get());
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (IcicleBlock.isIcicleFacingDirection(state, class_2350.field_11036) && !this.method_9558(state, (class_4538)world, pos)) {
            world.method_22352(pos, true);
        } else {
            this.spawnFallingIcicle(state, world, pos);
        }
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.maybeFillCauldron(state, world, pos, random.method_43057());
        if (random.method_43057() < 0.2f && IcicleBlock.isIcicleTip(state, (class_4538)world, pos)) {
            IcicleBlock.growStalactiteOrStalagmiteIfPossible(state, world, pos, random);
        }
        class_6880 biome = world.method_23753(pos);
        if (world.method_8314(class_1944.field_9282, pos) > 13 - state.method_26193((class_1922)world, pos) || world.method_27983() == class_1937.field_25180 || biome.method_40220(ModTags.HOT) && world.method_8530()) {
            world.method_8650(pos, false);
        }
    }

    public void maybeFillCauldron(class_2680 state, class_3218 world, class_2338 pos, float dripChance) {
        class_2338 blockPos2;
        class_2338 blockPos;
        class_3611 fluid;
        float f;
        if (!(dripChance > 0.2f) && IcicleBlock.isIcicleTip(state, (class_4538)world, pos) && world.method_8530() && !world.method_8419() && !world.method_8546() && !(dripChance >= (f = (fluid = IcicleBlock.method_32775((class_3218)world, (class_2338)pos)) == class_3612.field_15910 ? 0.17578125f : 0.05859375f)) && (blockPos = IcicleBlock.findTip(state, (class_1936)world, pos, 11, false)) != null && (blockPos2 = IcicleBlock.getCauldronPos((class_1937)world, blockPos)) != null) {
            world.method_20290(1504, blockPos, 0);
            int i = blockPos.method_10264() - blockPos2.method_10264();
            int j = 50 + i;
            class_2680 blockState = world.method_8320(blockPos2);
            world.method_39279(blockPos2, blockState.method_26204(), j);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 direction;
        class_2338 blockPos;
        class_1937 worldAccess = ctx.method_8045();
        class_2350 direction2 = IcicleBlock.calculateTipDirection((class_4538)worldAccess, blockPos = ctx.method_8037(), direction = ctx.method_32760().method_10153());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !ctx.method_8046();
        class_5691 thickness = IcicleBlock.calculateIcicleThickness((class_4538)worldAccess, blockPos, direction2, bl);
        return thickness == null ? null : (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_28050, (Comparable)direction2)).method_11657((class_2769)field_28051, (Comparable)thickness)).method_11657((class_2769)field_28052, (Comparable)Boolean.valueOf(worldAccess.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    public void method_10129(class_1937 world, class_2338 pos, class_1540 fallingBlockEntity) {
        if (!fallingBlockEntity.method_5701()) {
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)this.method_9564()));
        }
    }

    public class_1282 method_32898() {
        return ModDamageSource.FALLING_ICICLE;
    }

    private void spawnFallingIcicle(class_2680 state, class_3218 level, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        class_2680 blockstate = state;
        while (IcicleBlock.isIcicle(blockstate) && this.method_9558(blockstate, (class_4538)level, (class_2338)mutable)) {
            if (IcicleBlock.isTip(blockstate, true)) {
                if (class_2346.method_10128((class_2680)level.method_8320(mutable.method_10074()))) break;
                return;
            }
            mutable.method_10098(class_2350.field_11033);
            blockstate = level.method_8320((class_2338)mutable);
        }
        mutable = pos.method_25503();
        blockstate = state;
        while (IcicleBlock.isIcicle(blockstate)) {
            class_1540 fallingblockentity = FallingIcicleEntity.fall((class_1937)level, (class_2338)mutable, blockstate);
            if (IcicleBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + pos.method_10264() - mutable.method_10264(), 6);
                float f = i;
                fallingblockentity.method_6965(f, 40);
                break;
            }
            mutable.method_10098(class_2350.field_11033);
            blockstate = level.method_8320((class_2338)mutable);
        }
    }

    public static void growStalactiteOrStalagmiteIfPossible(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        class_2680 blockState3;
        class_2338 blockPos;
        class_2680 blockState2;
        class_2680 blockState = world.method_8320(pos.method_10086(1));
        if (IcicleBlock.canGrow(blockState, blockState2 = world.method_8320(pos.method_10086(2))) && world.method_8530() && !world.method_8419() && !world.method_8546() && (blockPos = IcicleBlock.findTip(state, (class_1936)world, pos, 7, false)) != null && IcicleBlock.canDrip(blockState3 = world.method_8320(blockPos)) && IcicleBlock.canTipGrow(blockState3, world, blockPos)) {
            if (random.method_43056()) {
                IcicleBlock.grow(world, blockPos, class_2350.field_11033);
            } else {
                IcicleBlock.growStalagmiteBelow(world, blockPos);
            }
        }
    }

    private static void growStalagmiteBelow(class_3218 world, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 0; i < 10; ++i) {
            mutable.method_10098(class_2350.field_11033);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (!blockState.method_26227().method_15769()) {
                return;
            }
            if (IcicleBlock.isUnmergedTipWithDirection(blockState, class_2350.field_11036) && IcicleBlock.canTipGrow(blockState, world, (class_2338)mutable)) {
                IcicleBlock.grow(world, (class_2338)mutable, class_2350.field_11036);
                return;
            }
            if (!IcicleBlock.isValidIciclePlacement((class_4538)world, (class_2338)mutable, class_2350.field_11036) || world.method_22351(mutable.method_10074())) continue;
            IcicleBlock.grow(world, mutable.method_10074(), class_2350.field_11036);
            return;
        }
    }

    private static void grow(class_3218 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (IcicleBlock.isUnmergedTipWithDirection(blockState, direction.method_10153())) {
            IcicleBlock.createMergedTips(blockState, (class_1936)world, blockPos);
        } else if (blockState.method_26215() || blockState.method_27852(class_2246.field_10382)) {
            IcicleBlock.createIcicle((class_1936)world, blockPos, direction, class_5691.field_28065);
        }
    }

    private static void createIcicle(class_1936 world, class_2338 pos, class_2350 direction, class_5691 thickness) {
        class_2680 blockState = (class_2680)((class_2680)((class_2680)ModBlocks.ICICLE.get().method_9564().method_11657((class_2769)field_28050, (Comparable)direction)).method_11657((class_2769)field_28051, (Comparable)thickness)).method_11657((class_2769)field_28052, (Comparable)Boolean.valueOf(world.method_8316(pos).method_15772() == class_3612.field_15910));
        world.method_8652(pos, blockState, 3);
    }

    private static void createMergedTips(class_2680 state, class_1936 world, class_2338 pos) {
        class_2338 blockPos2;
        class_2338 blockPos;
        if (state.method_11654((class_2769)field_28050) == class_2350.field_11036) {
            blockPos = pos;
            blockPos2 = pos.method_10084();
        } else {
            blockPos2 = pos;
            blockPos = pos.method_10074();
        }
        IcicleBlock.createIcicle(world, blockPos2, class_2350.field_11033, class_5691.field_28064);
        IcicleBlock.createIcicle(world, blockPos, class_2350.field_11036, class_5691.field_28064);
    }

    private static void spawnDripParticle(class_1937 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        class_243 vec3d = state.method_26226((class_1922)world, pos);
        double e = (double)pos.method_10263() + 0.5 + vec3d.field_1352;
        double f = pos.method_10264() + 0;
        double g = (double)pos.method_10260() + 0.5 + vec3d.field_1350;
        class_2400 particleEffect = class_2398.field_28078;
        world.method_8406((class_2394)particleEffect, e, f, g, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static class_2338 findTip(class_2680 state, class_1936 world, class_2338 pos, int range, boolean allowMerged) {
        if (IcicleBlock.isTip(state, allowMerged)) {
            return pos;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_28050);
        Predicate<class_2680> predicate = statex -> statex.method_27852(ModBlocks.ICICLE.get()) && statex.method_11654((class_2769)field_28050) == direction;
        return IcicleBlock.searchInDirection(world, pos, direction.method_10171(), predicate, statex -> IcicleBlock.isTip(statex, allowMerged), range).orElse(null);
    }

    @Nullable
    private static class_2350 calculateTipDirection(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2350 direction2;
        if (IcicleBlock.isValidIciclePlacement(world, pos, direction)) {
            direction2 = direction;
        } else {
            if (!IcicleBlock.isValidIciclePlacement(world, pos, direction.method_10153())) {
                return null;
            }
            direction2 = direction.method_10153();
        }
        return direction2;
    }

    private static class_5691 calculateIcicleThickness(class_4538 world, class_2338 pos, class_2350 direction, boolean tryMerge) {
        class_2350 direction2 = direction.method_10153();
        class_2680 blockState = world.method_8320(pos.method_10093(direction));
        if (IcicleBlock.isIcicleFacingDirection(blockState, direction2)) {
            return !tryMerge && blockState.method_11654((class_2769)field_28051) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!IcicleBlock.isIcicleFacingDirection(blockState, direction)) {
            return class_5691.field_28065;
        }
        class_5691 thickness = (class_5691)blockState.method_11654((class_2769)field_28051);
        if (thickness != class_5691.field_28065 && thickness != class_5691.field_28064) {
            class_2680 blockState2 = world.method_8320(pos.method_10093(direction2));
            return !IcicleBlock.isIcicleFacingDirection(blockState2, direction) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    public static boolean canDrip(class_2680 state) {
        return IcicleBlock.isIcicle(state) && state.method_11654((class_2769)field_28051) == class_5691.field_28065 && (Boolean)state.method_11654((class_2769)field_28052) == false;
    }

    private static boolean canTipGrow(class_2680 state, class_3218 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_28050);
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (!blockState.method_26227().method_15769()) {
            return false;
        }
        return blockState.method_26215() || IcicleBlock.isUnmergedTipWithDirection(blockState, direction.method_10153());
    }

    private static Optional<class_2338> getSupportingPos(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_28050);
        Predicate<class_2680> predicate = statex -> statex.method_27852(ModBlocks.ICICLE.get()) && statex.method_11654((class_2769)field_28050) == direction;
        return IcicleBlock.searchInDirection((class_1936)world, pos, direction.method_10153().method_10171(), predicate, statex -> !statex.method_27852(ModBlocks.ICICLE.get()), 11);
    }

    private static boolean isValidIciclePlacement(class_4538 world, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26164(class_3481.field_15503) || IcicleBlock.method_20044((class_4538)world, (class_2338)blockPos, (class_2350)direction) || IcicleBlock.isIcicleFacingDirection(blockState, direction);
    }

    private static boolean isTip(class_2680 state, boolean allowMerged) {
        if (!state.method_27852(ModBlocks.ICICLE.get())) {
            return false;
        }
        class_5691 thickness = (class_5691)state.method_11654((class_2769)field_28051);
        return thickness == class_5691.field_28065 || allowMerged && thickness == class_5691.field_28064;
    }

    private static boolean isUnmergedTipWithDirection(class_2680 state, class_2350 direction) {
        return IcicleBlock.isTip(state, false) && state.method_11654((class_2769)field_28050) == direction;
    }

    private static boolean isIcicle(class_2680 state) {
        return IcicleBlock.isIcicleFacingDirection(state, class_2350.field_11033);
    }

    private static boolean isIcicleTip(class_2680 state, class_4538 world, class_2338 pos) {
        return IcicleBlock.isIcicle(state) && !world.method_8320(pos.method_10084()).method_27852(ModBlocks.ICICLE.get());
    }

    private static boolean isIcicleFacingDirection(class_2680 state, class_2350 direction) {
        return state.method_27852(ModBlocks.ICICLE.get()) && state.method_11654((class_2769)field_28050) == direction;
    }

    @Nullable
    private static class_2338 getCauldronPos(class_1937 world, class_2338 pos) {
        Predicate<class_2680> predicate = state -> state.method_26204() instanceof class_2275;
        return IcicleBlock.searchInDirection((class_1936)world, pos, class_2350.field_11033.method_10171(), class_4970.class_4971::method_26215, predicate, 11).orElse(null);
    }

    public static class_3611 getCauldronFillFluidType(class_1937 world, class_2338 pos) {
        return IcicleBlock.getFluidAboveStalactite(world, pos, world.method_8320(pos)).filter(IcicleBlock::isValidDripFluid).orElse(class_3612.field_15906);
    }

    private static Optional<class_3611> getFluidAboveStalactite(class_1937 world, class_2338 pos, class_2680 state) {
        return !IcicleBlock.isIcicle(state) ? Optional.empty() : IcicleBlock.getSupportingPos(world, pos, state).map(posx -> world.method_8316(posx.method_10084()).method_15772());
    }

    private static boolean isValidDripFluid(class_3611 fluid) {
        return fluid == class_3612.field_15910;
    }

    private static boolean canGrow(class_2680 iceBlockState, class_2680 waterState) {
        return iceBlockState.method_26164(ModTags.ICE) && waterState.method_27852(class_2246.field_10382);
    }

    private static Optional<class_2338> searchInDirection(class_1936 world, class_2338 pos, class_2350.class_2352 direction, Predicate<class_2680> continuePredicate, Predicate<class_2680> stopPredicate, int range) {
        class_2350 direction2 = class_2350.method_10156((class_2350.class_2352)direction, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 1; i < range; ++i) {
            mutable.method_10098(direction2);
            class_2680 blockState = world.method_8320((class_2338)mutable);
            if (stopPredicate.test(blockState)) {
                return Optional.of(mutable.method_10062());
            }
            if (!world.method_31601(mutable.method_10264()) && continuePredicate.test(blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

